unit IWCompQuickTime;

interface

uses
  {$IFDEF VSNET}System.ComponentModel, System.Drawing, {$ENDIF}
  Classes,
  IWCompObject, IWHTMLTag, IWFileReference, IWColor, IWGlobal, IWRenderContext;

type
  TIWCustomQuickTime = class(TIWCustomObject)
  protected
    FAutoPlay: Boolean;
    FBGColor: TIWColor;
    FCache: Boolean;
    FController: Boolean;
    FHeight: Integer;
    FHidden: Boolean;
    FHRef: string;
    FKioskMode: boolean;
    FLoop: Boolean;
    FMovFile: TIWFileReference;
    FMovieName: string;
    FPan: Integer;
    FPlayEveryFrame: Boolean;
    FScale: string;
    FVolume: Integer;
    FWidth: Integer;

    procedure SetMovFile(const Value: TIWFileReference);
    procedure DoFileReferenceChage(Sender : TObject);
    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;    
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    property AutoPlay: Boolean read FAutoPlay write FAutoPlay;
    property BGColor: TIWColor read FBGColor write FBGColor;
    property Cache: Boolean read FCache write FCache;
    property Controller: Boolean read FController write FController;
    property Hidden: Boolean read FHidden write FHidden;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property HRef: string read FHRef write FHRef;
    property KioskMode: Boolean read FKioskMode write FKioskMode;
    property Loop: Boolean read FLoop write FLoop;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property MovFile: TIWFileReference read FMovFile write SetMovFile;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property MovieName: string read FMovieName write FMovieName;
    property Pan: Integer read FPan write FPan;
    property PlayEveryFrame: Boolean read FPlayEveryFrame write FPlayEveryFrame;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property Scale: string read FScale write FScale;
    property Volume: Integer read FVolume write FVolume;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWQuickTime.bmp}
  TIWQuickTime = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWQuickTime), 'TIWQuickTime.bmp')]
  {$ENDIF}
  TIWQuickTime = class(TIWCustomQuickTime)
  published
    property AutoPlay;
    property BGColor;
    property Cache;
    property Controller;

    property FriendlyName;
    property Height;
    property Hidden;
    property HRef;
    property KioskMode;
    property Loop;
    property PluginsPage;
    property MovFile;
    property MovieName;
    property Pan;
    property PlayEveryFrame;
    property Scale;
    property Volume;

    property Width;
  end;

implementation

uses
  SysUtils,
  SWSystem;

{ TIWCustomQuickTime }

procedure TIWCustomQuickTime.InitControl;
begin
  inherited;
  FCLassID := 'clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B';
  FCodeBase := 'http://www.apple.com/qtactivex/qtplugin.cab"';
  FPluginsPage := 'http://www.apple.com/quicktime/download/';
  FMovFile := TIWFileReference.Create;
  FRenderEmbed := True;
  Fhref := '';
  FMovieName := '';
  FScale := '';
end;

procedure TIWCustomQuickTime.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FMovFile);
  inherited;
end;

procedure TIWCustomQuickTime.DoFileReferenceChage(Sender: TObject);
begin
  if not (csDesigning in ComponentState) then
  begin
     CodeBase := GServerController.FilesURL;
     if CodeBase = '' then begin
        CodeBase := '/Files/';
     end;
     if CodeBase[1] = '/' then  // CodeBase[1] is safe here - CodeBase is never empty
        CodeBase := Copy(CodeBase, 2, Length(CodeBase) - 1);
     if Pos('../', CodeBase) <> 1 then
        CodeBase := '/../' + CodeBase;
     Data := CodeBase + ExtractFileName(MOVFile.Filename);
  end;
end;

function TIWCustomQuickTime.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Params.Clear;
  with FParams.Add do begin
    Name := 'AUTOPLAY';
    Value := IIF(AutoPlay, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'BGCOLOR';
    Value := ColorToRGBString(BGColor);
  end;
  with FParams.Add do begin
    Name := 'CACHE';
    Value := IIF(Cache, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'CONTROLLER';
    Value := IIF(Controller, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'HEIGHT';
    Value := IntToStr(Height);
  end;
  with FParams.Add do begin
    Name := 'HIDDEN';
    Value := IIF(Hidden, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'HREF';
    Value := HRef;
  end;
  with FParams.Add do begin
    Name := 'KIOSKMODE';
    Value := IIF(KioskMode, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'LOOP';
    Value := IIF(Loop, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'SRC';
    Value := MovFile.Location(GServerController.FilesURL);
    FFileReference := Value;
  end;
  with FParams.Add do begin
    Name := 'MOVIENAME';
    Value := MovieName;
  end;
  with FParams.Add do begin
    Name := 'PAN';
    Value := IntToStr(Pan);
  end;
  with FParams.Add do begin
    Name := 'PLAYEVERYFRAME';
    Value := IIF(PlayEveryFrame, 'TRUE', 'FALSE');
  end;
  with FParams.Add do begin
    Name := 'SCALE';
    Value := Scale;
  end;
  with FParams.Add do begin
    Name := 'VOLUME';
    Value := IntToStr(Volume);
  end;
  with FParams.Add do begin
    Name := 'WIDTH';
    Value := IntToStr(Width);
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWCustomQuickTime.SetMovFile(const Value: TIWFileReference);
begin
  FMovFile.Assign(Value);
  FFileReference := Value.Location(GServerController.FilesURL);
end;

end.
